/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.com/copyright-license

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

#include "/lib/util/colorspace.glsl"

uniform vec3 sunvec;

uniform vec4 daytime;

flat out mat2x3 lightColor;

#ifdef skypass
flat out vec3 sky_color;
#endif

uniform vec3 fogColor;

void getColorPalette() {
    lightColor[0]  = linearToAP1(normalize(toLinear(fogColor))) * 0.1;

    lightColor[1]  = blackbody(blocklightBaseTemp) * blocklightIllum * 2.0;


    #ifdef skypass
        sky_color    = vec3(1.0, 0.15, 0.1)*0.004;
        sky_color   = mix(sky_color, linearToAP1(toLinear(fogColor)) * 0.004, 0.7);
    #endif
}